# Кактус
Как и другие растения, [кактусы](objects/cactus) можно выращивать на грядках и собирать как обычно.

Однако они бывают разных размеров и обладают странным чувством порядка.

Если ты собираешь созревший кактус, а все соседние кактусы находятся в отсортированном порядке, дрон рекурсивно соберет и их.

Кактус находится в отсортированном порядке, если все соседние кактусы в направлениях `North` и `East` созрели и имеют больший или равный размер, а все соседние кактусы в направлениях `South` и `West` созрели и имеют меньший или равный размер.

Дрон соберет соседние кактусы только в том случае, если все они созрели и находятся в отсортированном порядке.
То есть, если созревшие кактусы в квадрате отсортированы по размеру, при сборе одного кактуса ты соберешь растения со всего квадрата.

Созревший кактус будет коричневым, если он не отсортирован. После сортировки он снова станет зеленым.

Ты получишь кактусы в количестве, равном квадрату числа собранных кактусов. Так, если ты соберешь `n` кактусов одновременно, то получишь `n**2` `Items.Cactus`.

Размер кактуса можно измерить с помощью `measure()`.
Он всегда выражается одним из этих чисел: `0,1,2,3,4,5,6,7,8,9`.

Также можно передать направление через `measure(direction)`, чтобы измерить соседнюю к дрону клетку в указанном направлении.

Ты можешь поменять кактус местами с его соседом в любом направлении с помощью команды `swap()`.
`swap(direction)` меняет местами объект под дроном с объектом, находящимся на одну клетку в указанном направлении `direction` от дрона.

## Примеры
На каждом из этих полей все кактусы находятся в отсортированном порядке, поэтому сбор распространится на все поле:
`3 4 5    3 3 3    1 2 3    1 5 9
2 3 4    2 2 2    1 2 3    1 3 8
1 2 3    1 1 1    1 2 3    1 3 4`

На этом поле только нижний левый кактус находится в отсортированном порядке, а этого недостаточно для сбора остальных:
`1 5 3
4 9 7
3 3 2`

<spoiler=показать подсказку 1>
Если строки отсортированы, сортировка столбцов не нарушит сортировку строк.
</spoiler>
<spoiler=show hint 2>
Если тебе не знакомы алгоритмы сортировки, попробуй поискать их в Интернете и подумать, какие можно адаптировать к этой задаче. Имей в виду, что не все из них подойдут, так как менять местами можно только соседние кактусы.
</spoiler>